(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     52663,       1672]*)
(*NotebookOutlinePosition[     77753,       2240]*)
(*  CellTagsIndexPosition[     75573,       2184]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Convert To ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["InputForm", "Command",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To InputForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel to convert StandardForm \
or TraditionalForm cells.\n\[FilledSmallSquare] The conversion process will \
remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] This command can convert \
PostScript, PICT, and Bitmap graphics into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " graphics primitives.\n\[FilledSmallSquare] This command can convert \
sounds into a list of numbers (samples) in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Notes",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"ConvertToInputForm"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1"],
  StyleBox["\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["I", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["I", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1"],
  StyleBox["\[KeyBar]\[KeyBar]", "C1"],
  StyleBox["\[Mod1Key]", "C1"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["I", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToInputForm"],

Cell["OutputForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To OutputForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["OutputForm", "MR"],
  "."
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],

Cell["StandardForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to StandardForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] When this command is applied to a text selection, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates an in-line cell."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"]
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["N", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["N", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["N", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToStandardForm"],

Cell["TraditionalForm", "Command",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to TraditionalForm", "SR"],
  " converts the selection to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] When this command is applied to a text selection, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates an in-line cell."
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] The expression is regenerated in the specified format \
type by the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "kernel. Syntactically incorrect expressions will generate an error.\n\
\[FilledSmallSquare] This command requires a kernel.\n\[FilledSmallSquare] \
The conversion process will remove any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " comments in the cell.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"]
}], "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["T", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["T", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  StyleBox[" \[ShiftKey]\[KeyBar]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["T", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ConvertToTraditionalForm"],

Cell["PostScript", "Command",
  CellTags->{"SelectionConvert", "PostScript"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To PostScript", "SR"],
  " converts the selected cell to PostScript format."
}], "Usage",
  CellTags->"PostScript"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells. (Macintosh only.)"], "Notes",
  CellTags->"PostScript"],

Cell["Bitmap", "Command",
  CellTags->{"SelectionConvert", "Bitmap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to Bitmap", "SR"],
  " converts the selected cell to a platform-independent bitmap format."
}], "Usage",
  CellTags->"Bitmap"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells. (Macintosh only.)"], "Notes",
  CellTags->"Bitmap"],

Cell["PICT", "Command",
  CellTags->{"SelectionConvert", "PICT"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to PICT ", "SR"],
  "converts the selected cell to Macintosh QuickDraw/PICT format.  (Macintosh \
only.)"
}], "Usage",
  CellTags->"PICT"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICT"],

Cell["BitmapPICT", "Command",
  CellTags->{"SelectionConvert", "PICTBitmap"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert to BitmapPICT", "SR"],
  " converts the selected cell to Macintosh QuickDraw/PICT format containing \
a bitmap of the cell. (Macintosh only.)"
}], "Usage",
  CellTags->"PICTBitmap"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICTBitmap"],

Cell["Embedded PS PICT", "Command",
  CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To Embedded PS PICT ", "SR"],
  "converts the selected cell to Macintosh QuickDraw/PICT format containing \
an embedded PostScript version of the cell.  (Macintosh only.)"
}], "Usage",
  CellTags->"PICTEmbeddedPS"],

Cell[TextData[
"\[FilledSmallSquare] QuickTime animations are converted to a sequence of \
graphics cells."], "Notes",
  CellTags->"PICTEmbeddedPS"],

Cell["QuickTime", "Command",
  CellTags->{"SelectionConvert", "QuickTime"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Convert To QuickTime", "SR"],
  " converts the selected sequence of graphics cells into a Macintosh \
QuickTime animation. (Macintosh only.)"
}], "Usage",
  CellTags->"QuickTime"],

Cell[TextData[{
  "Display As ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Text", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As Text", "SR"],
  " displays the selection as plain text without interpreting it."
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell[TextData[
"\[FilledSmallSquare] Reinterprets the selection as plain text form without \
changing it.\n\[FilledSmallSquare] If the cell contains structured typeset \
expressions (fractions, superscripts, etc) they are converted to linear \
syntax notation, not to InputForm as is done by the commands in the Convert \
To submenu."], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],

Cell["InputForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As InputForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  " without interpreting it."
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains structured typeset expressions \
(fractions, superscripts, etc.) they are converted to linear syntax notation, \
not to InputForm as is done by the commands in the Convert To submenu.\n\
\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],

Cell["StandardForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As StandardForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains expressions such as fractions or \
powers they are not converted to structured typeset form, as would be done by \
items in the Convert To submenu.\n\[FilledSmallSquare] See Reference Guide: ",
  
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],

Cell["TraditionalForm", "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Display As TraditionalForm", "SR"],
  " displays the selection in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the cell contains expressions such as fractions or \
powers they are not converted to structured typeset form, as would be done by \
items in the Convert To submenu.\n\[FilledSmallSquare] See Reference Guide: ",
  
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],

Cell[TextData[{
  "Default Input FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["InputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Input FormatType InputForm", "SR"],
  " sets the default for newly created cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing when the selection is a cell insertion point.\n\[FilledSmallSquare]  \
This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]InputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare]  ",
  StyleBox["Default Input FormatType StandardForm ", "SR"],
  "sets the default for newly created cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing when the selection is a cell insertion point.\n\[FilledSmallSquare]  \
This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]StandardForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Input FormatType TraditionalForm", "SR"],
  " sets the default for newly created cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is used when you create a new cell by \
typing when the selection is a cell insertion point.\n\[FilledSmallSquare]  \
This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Input\"\[Rule]TraditionalForm} ", "MR"],
  "on",
  StyleBox[" $FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],

Cell[TextData[{
  "Default Output FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["OutputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType OutputForm", "SR"],
  " sets the default for Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]OutputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["OutputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],

Cell["InputForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType InputForm", "SR"],
  " sets the default for Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["InputForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]InputForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["InputForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType StandardForm", "SR"],
  " sets the default for Output cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]StandardForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Output FormatType TraditionalForm", "SR"],
  " sets the default for Output cells to  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"Output\"\[Rule]TraditionalForm}", "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],

Cell[TextData[{
  "Default Inline FormatType ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["StandardForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Inline FormatType StandardForm", "SR"],
  " sets the default for in-line cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"TextInline\"\[Rule]StandardForm}", "MR"],
  
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["StandardForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],

Cell["TraditionalForm", "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Default Inline FormatType TraditionalForm", "SR"],
  " sets the default for in-line cells to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["TraditionalForm", "MR"],
  "."
}], "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox[
  "CommonDefaultFormatTypes\[Rule]{\"TextInline\"\[Rule]TraditionalForm}", 
    "MR"],
  " on ",
  StyleBox["$FrontEnd", "MR"],
  ".\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],

Cell[TextData[{
  "Cell Properties ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Cell Open", "Command",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Open", "SR"],
  " toggles a cell between open and closed. "
}], "Usage",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] When closed, a cell's contents are hidden.\n\
\[FilledSmallSquare]  This command toggles the option ",
  StyleBox["CellOpen", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"CellOpen"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Open/Close Group",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"CellOpen"],

Cell["Cell Editable", "Command",
  CellTags->"Editable"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Editable", "SR"],
  " toggles whether a cell can be edited."
}], "Usage",
  CellTags->"Editable"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is uneditable, the letter \"X\" appears \
in the cell bracket.\n\[FilledSmallSquare]  This command toggles the option ",
  
  StyleBox["Editable", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"Editable"],

Cell["Cell Edit Duplicate", "Command",
  CellTags->"CellEditDuplicate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Edit Duplicate", "SR"],
  " causes a new cell to be created whenever the selected cell is edited. "
}], "Usage",
  CellTags->"CellEditDuplicate"],

Cell[TextData[{
  "\[FilledSmallSquare] Typically a property of output cells.\n\
\[FilledSmallSquare]  This command toggles the option ",
  StyleBox["CellEditDuplicate", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"CellEditDuplicate"],

Cell["Cell Evaluatable", "Command",
  CellTags->"Evaluatable"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Evaluatable", "SR"],
  " toggles a cell between evaluatable and unevaluatable. Only evaluatable \
cells can be sent to the kernel. "
}], "Usage",
  CellTags->"Evaluatable"],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is unevaluatable, a horizontal dash (-)  \
appears in the cell bracket.\n\[FilledSmallSquare]  This command toggles the \
option ",
  StyleBox["Evaluatable", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"Evaluatable"],

Cell["Cell Active", "Command",
  CellTags->"Active"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Active", "SR"],
  " toggles a cell between active and inactive state."
}], "Usage",
  CellTags->"Active"],

Cell[TextData[
"\[FilledSmallSquare] Palette buttons within Active cells carry out their \
script when clicked on, while buttons inside inactive cells can be edited."], 
  "Notes",
  CellTags->"Active"],

Cell[TextData[
"\[FilledSmallSquare] When a cell is active, the letter \"A\" appears in the \
cell bracket.\n\[FilledSmallSquare]  This command toggles the option Active \
between True and False on the selected Cell objects."], "Notes",
  CellTags->"Active"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " book: ",
  ButtonBox["Section 1.3.6",
    ButtonData:>{"1.3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"Active"],

Cell["Initialization Cell", "Command",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Initialization Cell", "SR"],
  " makes a cell auto-evaluate whenever the notebook is opened."
}], "Usage",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] When a cell is an initialization cell, a vertical \
tick mark (|) appears in the cell bracket.\n\[FilledSmallSquare]  The ",
  StyleBox["Initialization Cell", "SR"],
  " command toggles the option ",
  StyleBox["InitializationCell", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  StyleBox["InitializationCellLoading", "MR"],
  ", set at the Notebook level, determines when the initializations cells in \
a notebook are evaluated:\n   ",
  StyleBox["InitializationCellLoading->True", "MR"],
  "  evaluates  initialization cells when the notebook is opened.\n   ",
  StyleBox["InitializationCellLoading->False", "MR"],
  " tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " not to evaluate initialization cells.\n   ",
  StyleBox["InitializationCellLoading->Automatic", "MR"],
  " loads the initialization cells only when you first do an evaluation \
within the notebook."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  StyleBox["InitializationCellWarning", "MR"],
  " determines whether you get a dialog box confirming that you want to \
evaluate the init cells, at the time determined by ",
  StyleBox["InitializationCellLoading", "MR"],
  ".  A dialog box will appear if ",
  StyleBox["InitializationCellWarning", "MR"],
  " is set True at either the Notebook or global level.  This provides a \
level of security, because an individual notebook cannot cause initialization \
cells to be loaded silently, unless ",
  StyleBox["InitializationCellWarning", "MR"],
  " is set False at the global level."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can evalate the initialization cells manually at \
any time by choosing ",
  StyleBox["Evaluate Initialization", "SR"],
  " from the Evaluation submenu of the Kernel menu."
}], "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],

Cell[TextData[{
  "Cell Grouping ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell["Group Cells", "Command",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Group Cells ", "SR"],
  "makes a group out of the selected sequence of cells. "
}], "Usage",
  CellTags->"CellGroup"],

Cell[TextData[
"\[FilledSmallSquare] This command is only available when cell grouping is \
set to manual.\n\[FilledSmallSquare] The grouping of cells is indicated by \
nested brackets on the right of the notebook."], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] When you use ",
  StyleBox["Group Cells", "SR"],
  " on a selection in which the beginning cells are already grouped, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " incorporates the remaining ungrouped cells into the existing group."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[
"\[FilledSmallSquare] A cell cannot be the first cell in more than one group \
at the same time."], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " book: ",
  ButtonBox["Section 1.3.5",
    ButtonData:>{"1.3.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"CellGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["G", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["G", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["G", "C1MR"],
  StyleBox["\[RightModified]", "C1"],
  " ",
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellGroup"],

Cell["Ungroup Cells", "Command",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Ungroup Cells", "SR"],
  " ungroups the selected sequence of cells."
}], "Usage",
  CellTags->"CellUnGroup"],

Cell[TextData[
"\[FilledSmallSquare] This command is only available when cell grouping is \
set to manual.\n\[FilledSmallSquare] When there are subgroups within the \
selection, they are left as is."], "Notes",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] If the selection is a range of cells at the bottom of \
a grouping, but not the whole group, ",
  StyleBox["Ungroup Cells", "SR"],
  " removes those cells from the group but does not destroy the whole group."
}], "Notes",
  CellTags->"CellUnGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["U", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["U", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  StyleBox["\[ShiftKey]\[KeyBar]", "C1"],
  StyleBox["\[Mod1Key]", "C1MR"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["U", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellUngroup"],

Cell["Manual Grouping", "Command",
  CellTags->"CellGroupingManual"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Manual Grouping", "SR"],
  " lets you group cells by hand."
}], "Usage",
  CellTags->"CellGroupingManual"],

Cell[TextData[{
  "\[FilledSmallSquare]  This command sets the option ",
  StyleBox["CellGrouping\[Rule]Manual", "MR"],
  " on the selected Notebook.\n\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["CellGrouping",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"CellGroupingManual"],

Cell["Automatic Grouping", "Command",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Automatic Grouping", "SR"],
  " automatically creates hierarchical cell groups on the basis of cell \
style."
}], "Usage",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] Automatic Grouping varies in its treatment of \
different kinds of cells. Input cells, for example, form groups automatically \
only when followed by Output cells. Graphics cells form groups automatically \
only when followed by other Graphics cells. \n\[FilledSmallSquare] The \
grouping behavior of cells is controlled by the ",
  StyleBox["CellGroupingRules", "MR"],
  " option.\n\[FilledSmallSquare] Any groups you have created manually will \
be ignored when Automatic Grouping is selected.\n\[FilledSmallSquare] This \
command sets the option ",
  StyleBox["CellGrouping\[Rule]Automatic", "MR"],
  " on the selected Notebook."
}], "Notes",
  CellTags->"CellGroupingAutomatic"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["CellGrouping",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"CellGroupingAutomatic"],

Cell["Open All Subgroups", "Command",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open All Subgroups", "SR"],
  " opens all groups in the current selection."
}], "Usage",
  CellTags->"SelectionOpenAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["{", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionOpenAllGroups"],

Cell["Close All Subgroups", "Command",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Close All Subgroups", "SR"],
  " closes all groups in the current selection."
}], "Usage",
  CellTags->"SelectionCloseAllGroups"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh);", "Notes"],
  " ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["}", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionCloseAllGroups"],

Cell["Open/Close Group", "Command",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open/Close Group", "SR"],
  " toggles a cell group between open and closed. Closing a group collapses \
all cells in the group so that only the head cell is visible."
}], "Usage",
  CellTags->"OpenCloseGroup"],

Cell[TextData[
"\[FilledSmallSquare] You can also close or open a group of cells by \
double-clicking the bracket that spans a group of cells."], "Notes",
  CellTags->"OpenCloseGroup"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["'", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"OpenCloseGroup"],

Cell["Divide Cell", "Command",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Divide Cell", "SR"],
  " splits a cell at the current insertion point. "
}], "Usage",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "This command splits the selected cell into two or three cells, depending \
on the current text selection. "
}], "Notes",
  CellTags->"CellSplit"],

Cell[TextData[
"\[FilledSmallSquare] An insertion point divides the cell in two. A  text \
selection divides the cell into three cells: everything before the beginning \
of the selection, the selection itself, and everything after the end of the \
selection."], "Notes",
  CellTags->"CellSplit"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["D", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["D", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["D", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellSplit"],

Cell["Merge Cell", "Command",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Merge Cell", "SR"],
  " combines the selected sequence of cells into one cell. "
}], "Usage",
  CellTags->"CellMerge"],

Cell[TextData[
"\[FilledSmallSquare] If the selection contains a mixture of text and typeset \
or graphics cells, the result is a text cell will with inline  typeset and/or \
graphics cells."], "Notes",
  CellTags->"CellMerge"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["M", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["M", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]", "C1MR"],
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["M", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"CellMerge"],

Cell["Animate Selected Graphics", "Command",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Animate Selected Graphics", "SR"],
  " animates graphics in the current selection, typically a cell group."
}], "Usage",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The \"movie\" is displayed in the position of the first graphics cell; you \
may need to scroll to make the first graphics cell visible."
}], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[
"\[FilledSmallSquare] Double-clicking a graphic in a group of cells also \
starts the animation."], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  StyleBox[" ",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectionAnimate"],

Cell[TextData[StyleBox["Animation Controls and Settings",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->"SelectionAnimate"],

Cell[TextData[{
  "\[FilledSmallSquare] To stop the animation, click anywhere in the \
notebook, or press any key.  A palette of speed and direction control buttons \
appears in the notebook window when the animation starts.\n\
\[FilledSmallSquare]  These buttons set the options ",
  StyleBox["AnimationDisplayTime", "MR"],
  " and ",
  StyleBox["AnimationCycleOffset", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"SelectionAnimate"],

Cell[TextData[
"\[FilledSmallSquare] You can also use the  following keyboard commands:"], 
  "Notes",
  CellTags->"SelectionAnimate"],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["\(Run\\ animation\\ forward\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\[Rule]"},
            {
              StyleBox["\(Run\\ animation\\ backward\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\( \[LeftArrow] \\ \)"},
            {
              StyleBox["\(Move\\ one\\ frame\\ forward, \\ stop\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "\[DownArrow]"},
            {
              RowBox[{
                StyleBox["\(Move\\ one\\ frame\\ backward\)",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                StyleBox[",",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox["stop",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman"]}], "\[UpArrow]"},
            {
              StyleBox["\(Run\\ animation\\ cyclically\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "c"},
            {
              StyleBox["\(Speed\\ up\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], ">"},
            {
              StyleBox["\(Slow\\ down\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], "<"},
            {
              StyleBox["\(Set\\ animation\\ speed\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              RowBox[{
                RowBox[{
                  StyleBox["1",
                    FontFamily->"Helvetica",
                    FontSize->9], 
                  StyleBox["\((slow)\)",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}]}], 
                
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->10,
                  FontWeight->"Roman",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                StyleBox["-",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontSize->9], 
                RowBox[{
                  StyleBox["9",
                    FontFamily->"Helvetica",
                    FontSize->9], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  StyleBox["\((fast)\)",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Plain",
                    FontTracking->"Plain",
                    PrivateFontOptions->{
                    "FontPostScriptName"->Automatic}]}]}]},
            {
              StyleBox["\(Stop\\ animation\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"], 
              StyleBox["\(any\\ key\\ press\\ or\\ mouse\\ click\)",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Roman"]}
            },
          GridFrame->False,
          RowLines->{True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  ShowCellBracket->False,
  AutoSpacing->False,
  CellTags->"SelectionAnimate"],

Cell["Play Sound", "Command",
  CellTags->"SoundPlay"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Play Sound", "SR"],
  " plays sounds in the selected cells."
}], "Usage",
  CellTags->"SoundPlay"],

Cell[TextData[
"\[FilledSmallSquare] You can also play a sound by double-clicking the \
speaker-shaped icon at the top of the cell's bracket. "], "Notes",
  CellTags->"SoundPlay"],

Cell[TextData[
"\[FilledSmallSquare] If the sound is not part of an animation, \
double-clicking the sound graphic itself plays the sound repeatedly in a \
loop. To interrupt the loop, click outside the sound cell."], "Notes",
  CellTags->"SoundPlay"],

Cell["Rerender Graphics", "Command",
  CellTags->"GraphicsRender"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rerender Graphics", "SR"],
  " rerenders the selected graphics. This command renders all the selected \
cells that contain PostScript graphics."
}], "Usage",
  CellTags->"GraphicsRender"],

Cell[TextData[
"\[FilledSmallSquare] You might need to use this command if the graphics \
cells were previously rendered with different screen settings."], "Notes",
  CellTags->"GraphicsRender"],

Cell["Rerender and Save Graphics", "Command",
  CellTags->"GenerateImageCaches"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Rerender and Save Graphics", "SR"],
  " generates and saves image caches for all graphics cells"
}], "Usage",
  CellTags->"GenerateImageCaches"],

Cell["Make Standard Size", "Command",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make Standard Size", "SR"],
  " restores graphics to the default size."
}], "Usage",
  CellTags->"GraphicsOriginalSize"],

Cell[TextData[{
  "\[FilledSmallSquare] For PICT, QuickTime, and Bitmap graphics, the graphic \
itself defines its \"normal\" size (Macintosh only).  For PostScript \
graphics, the standard size is determined by the aspect ratio defined within \
the graphic, or by the BoundingBox PostScript comment, if present.\n\
\[FilledSmallSquare]  This command sets the option ",
  StyleBox["ImageSize", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->"GraphicsOriginalSize"],

Cell["Align Selected Graphics...", "Command",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Align Selected Graphics", "SR"],
  " makes selected graphics cells line up with the first graphic in the \
selection."
}], "Usage",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[
"\[FilledSmallSquare] In the dialog box specify which edges of the graphics \
(left, right, top, or bottom) you want aligned. Specified edges are aligned \
with those of the first selected graphics cell."], "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[
"\[FilledSmallSquare] When left and right are specified, all graphics are set \
to the same width. When  top and bottom are specified, all  graphics are made \
the same height.  When all four edges are specified, all  graphics are made \
the same size."], "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell[TextData[{
  "\[FilledSmallSquare] This command is useful for aligning animated \
graphics.\n\[FilledSmallSquare]  This command sets the options ",
  StyleBox["ImageSize", "MR"],
  " and ",
  StyleBox["ImageMargins", "MR"],
  " on the selected Cell objects."
}], "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],

Cell["Cell Size Statistics...", "Command",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Size Statistics", "SR"],
  " gives statistics for cells within the current notebook."
}], "Usage",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[CellGroupData[{

Cell["Total Bytes", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell["Includes overhead for cell data structures.", "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Content Bytes", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell["\<\
Gives the size of text data only.  This corresponds to a character \
count of the text.\
\>", "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reflect Sharing", "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[TextData[{
  "Specifies whether infomation that is shared by more than one cell should \
be counted.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stores only one copy of a given token (variable name, etc.), even if it \
is used many times.  Therefore, it is not possible to assign the memory used \
by shared objects to any particular cell.  If Reflect Sharing is off, all \
memory will be counted as if it were not shared, which will over count the \
actual memory being used.  If Reflect Sharing is on, each cell will be \
assigned the memory used by the token divided by the number of times the \
token is shared."
}], "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
WindowSize->{520, 534},
WindowMargins->{{9, Automatic}, {Automatic, 24}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ConvertToInputForm"->{
    Cell[1806, 55, 62, 1, 34, "Command",
      CellTags->"ConvertToInputForm"],
    Cell[1871, 58, 261, 10, 29, "Usage",
      CellTags->"ConvertToInputForm"],
    Cell[2135, 70, 876, 21, 144, "Notes",
      CellTags->"ConvertToInputForm"],
    Cell[3014, 93, 175, 6, 22, "Notes",
      CellTags->"ConvertToInputForm"],
    Cell[3192, 101, 785, 23, 22, "Notes",
      CellTags->"ConvertToInputForm"]},
  "SelectionConvert"->{
    Cell[3980, 126, 86, 1, 34, "Command",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4069, 129, 285, 10, 29, "Usage",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4357, 141, 616, 15, 96, "Notes",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4976, 158, 90, 1, 34, "Command",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5069, 161, 291, 10, 29, "Usage",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5363, 173, 246, 6, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5612, 181, 613, 14, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[6948, 219, 96, 1, 70, "Command",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7047, 222, 301, 10, 70, "Usage",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7351, 234, 249, 6, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7603, 242, 619, 14, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[8942, 279, 77, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PostScript"}],
    Cell[9368, 294, 69, 1, 70, "Command",
      CellTags->{"SelectionConvert", "Bitmap"}],
    Cell[9793, 309, 65, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICT"}],
    Cell[10206, 325, 77, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICTBitmap"}],
    Cell[10680, 341, 87, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
    Cell[11201, 357, 75, 1, 70, "Command",
      CellTags->{"SelectionConvert", "QuickTime"}]},
  "ConvertToOutputForm"->{
    Cell[3980, 126, 86, 1, 34, "Command",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4069, 129, 285, 10, 29, "Usage",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
    Cell[4357, 141, 616, 15, 96, "Notes",
      CellTags->{"SelectionConvert", "ConvertToOutputForm"}]},
  "ConvertToStandardForm"->{
    Cell[4976, 158, 90, 1, 34, "Command",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5069, 161, 291, 10, 29, "Usage",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5363, 173, 246, 6, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[5612, 181, 613, 14, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
    Cell[6228, 197, 717, 20, 70, "Notes",
      CellTags->"ConvertToStandardForm"]},
  "ConvertToTraditionalForm"->{
    Cell[6948, 219, 96, 1, 70, "Command",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7047, 222, 301, 10, 70, "Usage",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7351, 234, 249, 6, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[7603, 242, 619, 14, 70, "Notes",
      CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
    Cell[8225, 258, 714, 19, 70, "Notes",
      CellTags->"ConvertToTraditionalForm"]},
  "PostScript"->{
    Cell[8942, 279, 77, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PostScript"}],
    Cell[9022, 282, 178, 5, 70, "Usage",
      CellTags->"PostScript"],
    Cell[9203, 289, 162, 3, 70, "Notes",
      CellTags->"PostScript"]},
  "Bitmap"->{
    Cell[9368, 294, 69, 1, 70, "Command",
      CellTags->{"SelectionConvert", "Bitmap"}],
    Cell[9440, 297, 189, 5, 70, "Usage",
      CellTags->"Bitmap"],
    Cell[9632, 304, 158, 3, 70, "Notes",
      CellTags->"Bitmap"]},
  "PICT"->{
    Cell[9793, 309, 65, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICT"}],
    Cell[9861, 312, 201, 6, 70, "Usage",
      CellTags->"PICT"],
    Cell[10065, 320, 138, 3, 70, "Notes",
      CellTags->"PICT"]},
  "PICTBitmap"->{
    Cell[10206, 325, 77, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICTBitmap"}],
    Cell[10286, 328, 244, 6, 70, "Usage",
      CellTags->"PICTBitmap"],
    Cell[10533, 336, 144, 3, 70, "Notes",
      CellTags->"PICTBitmap"]},
  "PICTEmbeddedPS"->{
    Cell[10680, 341, 87, 1, 70, "Command",
      CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
    Cell[10770, 344, 277, 6, 70, "Usage",
      CellTags->"PICTEmbeddedPS"],
    Cell[11050, 352, 148, 3, 70, "Notes",
      CellTags->"PICTEmbeddedPS"]},
  "QuickTime"->{
    Cell[11201, 357, 75, 1, 70, "Command",
      CellTags->{"SelectionConvert", "QuickTime"}],
    Cell[11279, 360, 234, 6, 70, "Usage",
      CellTags->"QuickTime"]},
  "SelectionDisplayAs"->{
    Cell[11613, 374, 80, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[11696, 377, 216, 5, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[11915, 384, 402, 6, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[12320, 392, 86, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12409, 395, 308, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12720, 407, 428, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[13151, 418, 92, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13246, 421, 294, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13543, 433, 399, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13945, 444, 98, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14046, 447, 303, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14352, 459, 405, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]},
  "DisplayAsTextForm"->{
    Cell[11613, 374, 80, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[11696, 377, 216, 5, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
    Cell[11915, 384, 402, 6, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}]},
  "DisplayAsInputForm"->{
    Cell[12320, 392, 86, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12409, 395, 308, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
    Cell[12720, 407, 428, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}]},
  "DisplayAsStandardForm"->{
    Cell[13151, 418, 92, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13246, 421, 294, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
    Cell[13543, 433, 399, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}]},
  "DisplayAsTraditionalForm"->{
    Cell[13945, 444, 98, 1, 70, "Command",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14046, 447, 303, 10, 70, "Usage",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
    Cell[14352, 459, 405, 9, 70, "Notes",
      CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}]},
  "MenuListCommonDefaultFormatTypesInputInput"->{
    Cell[14871, 476, 86, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
    Cell[14960, 479, 317, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
    Cell[15280, 491, 513, 13, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputInput"]},
  "MenuListCommonDefaultFormatTypesInputStandard"->{
    Cell[15796, 506, 92, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
    Cell[15891, 509, 326, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
    Cell[16220, 521, 522, 13, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputStandard"]},
  "MenuListCommonDefaultFormatTypesInputTraditional"->{
    Cell[16745, 536, 98, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
    Cell[16846, 539, 335, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
    Cell[17184, 551, 531, 13, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"]},
  "MenuListCommonDefaultFormatTypesOutputOutput"->{
    Cell[17830, 572, 89, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
    Cell[17922, 575, 315, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
    Cell[18240, 587, 388, 11, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"]},
  "MenuListCommonDefaultFormatTypesOutputInput"->{
    Cell[18631, 600, 87, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
    Cell[18721, 603, 311, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
    Cell[19035, 615, 385, 11, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputInput"]},
  "MenuListCommonDefaultFormatTypesOutputStandard"->{
    Cell[19423, 628, 93, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
    Cell[19519, 631, 320, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
    Cell[19842, 643, 394, 11, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"]},
  "MenuListCommonDefaultFormatTypesOutputTraditional"->{
    Cell[20239, 656, 99, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
    Cell[20341, 659, 330, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
    Cell[20674, 671, 403, 11, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"]},
  "MenuListCommonDefaultFormatTypesTextInlineStandard"->{
    Cell[21192, 690, 97, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
    Cell[21292, 693, 325, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
    Cell[21620, 705, 405, 12, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"]},
  "MenuListCommonDefaultFormatTypesTextInlineTraditional"->{
    Cell[22028, 719, 103, 1, 70, "Command",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
    Cell[22134, 722, 334, 10, 70, "Usage",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
    Cell[22471, 734, 416, 12, 70, "Notes",
      CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"]},
  "CellOpen"->{
    Cell[22992, 754, 52, 1, 45, "Command",
      CellTags->"CellOpen"],
    Cell[23047, 757, 156, 5, 40, "Usage",
      CellTags->"CellOpen"],
    Cell[23206, 764, 323, 10, 67, "Notes",
      CellTags->"CellOpen"],
    Cell[23532, 776, 164, 6, 33, "Notes",
      CellTags->"CellOpen"]},
  "Editable"->{
    Cell[23699, 784, 56, 1, 34, "Command",
      CellTags->"Editable"],
    Cell[23758, 787, 157, 5, 29, "Usage",
      CellTags->"Editable"],
    Cell[23918, 794, 356, 11, 56, "Notes",
      CellTags->"Editable"]},
  "CellEditDuplicate"->{
    Cell[24277, 807, 71, 1, 34, "Command",
      CellTags->"CellEditDuplicate"],
    Cell[24351, 810, 205, 5, 29, "Usage",
      CellTags->"CellEditDuplicate"],
    Cell[24559, 817, 336, 10, 56, "Notes",
      CellTags->"CellEditDuplicate"]},
  "Evaluatable"->{
    Cell[24898, 829, 62, 1, 34, "Command",
      CellTags->"Evaluatable"],
    Cell[24963, 832, 232, 6, 43, "Usage",
      CellTags->"Evaluatable"],
    Cell[25198, 840, 370, 11, 56, "Notes",
      CellTags->"Evaluatable"]},
  "Active"->{
    Cell[25571, 853, 52, 1, 34, "Command",
      CellTags->"Active"],
    Cell[25626, 856, 165, 5, 29, "Usage",
      CellTags->"Active"],
    Cell[25794, 863, 202, 4, 36, "Notes",
      CellTags->"Active"],
    Cell[25999, 869, 258, 4, 42, "Notes",
      CellTags->"Active"],
    Cell[26260, 875, 246, 10, 22, "Notes",
      CellTags->"Active"]},
  "InitializationCell"->{
    Cell[26509, 887, 93, 1, 34, "Command",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[26605, 890, 216, 5, 29, "Usage",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[26824, 897, 461, 12, 56, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27288, 911, 728, 16, 138, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28019, 929, 707, 14, 92, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28729, 945, 284, 6, 36, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}]},
  "askIfInitNoteID"->{
    Cell[26509, 887, 93, 1, 34, "Command",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[26605, 890, 216, 5, 29, "Usage",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[26824, 897, 461, 12, 56, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[27288, 911, 728, 16, 138, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28019, 929, 707, 14, 92, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}],
    Cell[28729, 945, 284, 6, 36, "Notes",
      CellTags->{"InitializationCell", "askIfInitNoteID"}]},
  "CellGroup"->{
    Cell[29116, 959, 55, 1, 34, "Command",
      CellTags->"CellGroup"],
    Cell[29174, 962, 172, 5, 29, "Usage",
      CellTags->"CellGroup"],
    Cell[29349, 969, 251, 4, 42, "Notes",
      CellTags->"CellGroup"],
    Cell[29603, 975, 353, 9, 47, "Notes",
      CellTags->"CellGroup"],
    Cell[29959, 986, 148, 3, 33, "Notes",
      CellTags->"CellGroup"],
    Cell[30110, 991, 249, 10, 33, "Notes",
      CellTags->"CellGroup"],
    Cell[30362, 1003, 695, 20, 33, "Notes",
      CellTags->"CellGroup"]},
  "CellUnGroup"->{
    Cell[31060, 1025, 59, 1, 45, "Command",
      CellTags->"CellUnGroup"],
    Cell[31122, 1028, 163, 5, 40, "Usage",
      CellTags->"CellUnGroup"],
    Cell[31288, 1035, 237, 4, 53, "Notes",
      CellTags->"CellUnGroup"],
    Cell[31528, 1041, 288, 6, 47, "Notes",
      CellTags->"CellUnGroup"]},
  "CellUngroup"->{
    Cell[31819, 1049, 737, 21, 33, "Notes",
      CellTags->"CellUngroup"]},
  "CellGroupingManual"->{
    Cell[32559, 1072, 68, 1, 45, "Command",
      CellTags->"CellGroupingManual"],
    Cell[32630, 1075, 161, 5, 40, "Usage",
      CellTags->"CellGroupingManual"],
    Cell[32794, 1082, 310, 8, 53, "Notes",
      CellTags->"CellGroupingManual"]},
  "CellGroupingAutomatic"->{
    Cell[33107, 1092, 74, 1, 70, "Command",
      CellTags->"CellGroupingAutomatic"],
    Cell[33184, 1095, 214, 6, 70, "Usage",
      CellTags->"CellGroupingAutomatic"],
    Cell[33401, 1103, 722, 13, 70, "Notes",
      CellTags->"CellGroupingAutomatic"],
    Cell[34126, 1118, 181, 6, 70, "Notes",
      CellTags->"CellGroupingAutomatic"]},
  "SelectionOpenAllGroups"->{
    Cell[34310, 1126, 75, 1, 70, "Command",
      CellTags->"SelectionOpenAllGroups"],
    Cell[34388, 1129, 181, 5, 70, "Usage",
      CellTags->"SelectionOpenAllGroups"],
    Cell[34572, 1136, 768, 23, 70, "Notes",
      CellTags->"SelectionOpenAllGroups"]},
  "SelectionCloseAllGroups"->{
    Cell[35343, 1161, 77, 1, 70, "Command",
      CellTags->"SelectionCloseAllGroups"],
    Cell[35423, 1164, 184, 5, 70, "Usage",
      CellTags->"SelectionCloseAllGroups"],
    Cell[35610, 1171, 769, 23, 70, "Notes",
      CellTags->"SelectionCloseAllGroups"]},
  "OpenCloseGroup"->{
    Cell[36382, 1196, 65, 1, 70, "Command",
      CellTags->"OpenCloseGroup"],
    Cell[36450, 1199, 264, 6, 70, "Usage",
      CellTags->"OpenCloseGroup"],
    Cell[36717, 1207, 184, 3, 70, "Notes",
      CellTags->"OpenCloseGroup"],
    Cell[36904, 1212, 593, 18, 70, "Notes",
      CellTags->"OpenCloseGroup"]},
  "CellSplit"->{
    Cell[37500, 1232, 55, 1, 70, "Command",
      CellTags->"CellSplit"],
    Cell[37558, 1235, 165, 5, 70, "Usage",
      CellTags->"CellSplit"],
    Cell[37726, 1242, 191, 5, 70, "Notes",
      CellTags->"CellSplit"],
    Cell[37920, 1249, 295, 5, 70, "Notes",
      CellTags->"CellSplit"],
    Cell[38218, 1256, 720, 21, 70, "Notes",
      CellTags->"CellSplit"]},
  "CellMerge"->{
    Cell[38941, 1279, 54, 1, 70, "Command",
      CellTags->"CellMerge"],
    Cell[38998, 1282, 173, 5, 70, "Usage",
      CellTags->"CellMerge"],
    Cell[39174, 1289, 227, 4, 70, "Notes",
      CellTags->"CellMerge"],
    Cell[39404, 1295, 720, 21, 70, "Notes",
      CellTags->"CellMerge"]},
  "SelectionAnimate"->{
    Cell[40127, 1318, 76, 1, 70, "Command",
      CellTags->"SelectionAnimate"],
    Cell[40206, 1321, 207, 5, 70, "Usage",
      CellTags->"SelectionAnimate"],
    Cell[40416, 1328, 228, 5, 70, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[40647, 1335, 155, 3, 70, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[40805, 1340, 639, 19, 70, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[41447, 1361, 130, 2, 70, "Subsubsection",
      CellTags->"SelectionAnimate"],
    Cell[41580, 1365, 457, 10, 70, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[42040, 1377, 134, 3, 70, "Notes",
      CellTags->"SelectionAnimate"],
    Cell[42177, 1382, 5125, 134, 70, "Text",
      CellTags->"SelectionAnimate"]},
  "SoundPlay"->{
    Cell[47305, 1518, 54, 1, 70, "Command",
      CellTags->"SoundPlay"],
    Cell[47362, 1521, 153, 5, 70, "Usage",
      CellTags->"SoundPlay"],
    Cell[47518, 1528, 179, 3, 70, "Notes",
      CellTags->"SoundPlay"],
    Cell[47700, 1533, 251, 4, 70, "Notes",
      CellTags->"SoundPlay"]},
  "GraphicsRender"->{
    Cell[47954, 1539, 66, 1, 70, "Command",
      CellTags->"GraphicsRender"],
    Cell[48023, 1542, 242, 6, 70, "Usage",
      CellTags->"GraphicsRender"],
    Cell[48268, 1550, 194, 3, 70, "Notes",
      CellTags->"GraphicsRender"]},
  "GenerateImageCaches"->{
    Cell[48465, 1555, 80, 1, 70, "Command",
      CellTags->"GenerateImageCaches"],
    Cell[48548, 1558, 199, 5, 70, "Usage",
      CellTags->"GenerateImageCaches"]},
  "GraphicsOriginalSize"->{
    Cell[48750, 1565, 73, 1, 70, "Command",
      CellTags->"GraphicsOriginalSize"],
    Cell[48826, 1568, 175, 5, 70, "Usage",
      CellTags->"GraphicsOriginalSize"],
    Cell[49004, 1575, 484, 9, 70, "Notes",
      CellTags->"GraphicsOriginalSize"]},
  "GraphicsAlign"->{
    Cell[49491, 1586, 103, 1, 70, "Command",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[49597, 1589, 244, 6, 70, "Usage",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[49844, 1597, 288, 4, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50135, 1603, 337, 5, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50475, 1610, 334, 8, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}]},
  "alignGraphicsSettingsID"->{
    Cell[49491, 1586, 103, 1, 70, "Command",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[49597, 1589, 244, 6, 70, "Usage",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[49844, 1597, 288, 4, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50135, 1603, 337, 5, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
    Cell[50475, 1610, 334, 8, 70, "Notes",
      CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}]},
  "NotebookStatisticsDialog"->{
    Cell[50812, 1620, 114, 1, 70, "Command",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[50929, 1623, 230, 5, 70, "Usage",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51184, 1632, 105, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51292, 1635, 139, 1, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51468, 1641, 107, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51578, 1644, 191, 4, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51806, 1653, 109, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51918, 1656, 729, 13, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]},
  "notebookStatisticsDialogID"->{
    Cell[50812, 1620, 114, 1, 70, "Command",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[50929, 1623, 230, 5, 70, "Usage",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51184, 1632, 105, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51292, 1635, 139, 1, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51468, 1641, 107, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51578, 1644, 191, 4, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51806, 1653, 109, 1, 70, "DialogItem",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
    Cell[51918, 1656, 729, 13, 70, "IndentedText",
      CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ConvertToInputForm", 53389, 1693},
  {"SelectionConvert", 53815, 1704},
  {"ConvertToOutputForm", 55579, 1739},
  {"ConvertToStandardForm", 55921, 1746},
  {"ConvertToTraditionalForm", 56461, 1757},
  {"PostScript", 57002, 1768},
  {"Bitmap", 57256, 1775},
  {"PICT", 57496, 1782},
  {"PICTBitmap", 57737, 1789},
  {"PICTEmbeddedPS", 58002, 1796},
  {"QuickTime", 58274, 1803},
  {"SelectionDisplayAs", 58468, 1808},
  {"DisplayAsTextForm", 59785, 1833},
  {"DisplayAsInputForm", 60125, 1840},
  {"DisplayAsStandardForm", 60472, 1847},
  {"DisplayAsTraditionalForm", 60831, 1854},
  {"MenuListCommonDefaultFormatTypesInputInput", 61217, 1861},
  {"MenuListCommonDefaultFormatTypesInputStandard", 61589, 1868},
  {"MenuListCommonDefaultFormatTypesInputTraditional", 61973, 1875},
  {"MenuListCommonDefaultFormatTypesOutputOutput", 62362, 1882},
  {"MenuListCommonDefaultFormatTypesOutputInput", 62738, 1889},
  {"MenuListCommonDefaultFormatTypesOutputStandard", 63114, 1896},
  {"MenuListCommonDefaultFormatTypesOutputTraditional", 63502, 1903},
  {"MenuListCommonDefaultFormatTypesTextInlineStandard", 63900, 1910},
  {"MenuListCommonDefaultFormatTypesTextInlineTraditional", 64304, 1917},
  {"CellOpen", 64673, 1924},
  {"Editable", 64976, 1933},
  {"CellEditDuplicate", 65217, 1940},
  {"Evaluatable", 65479, 1947},
  {"Active", 65718, 1954},
  {"InitializationCell", 66092, 1965},
  {"askIfInitNoteID", 66733, 1978},
  {"CellGroup", 67368, 1991},
  {"CellUnGroup", 67896, 2006},
  {"CellUngroup", 68217, 2015},
  {"CellGroupingManual", 68320, 2018},
  {"CellGroupingAutomatic", 68597, 2025},
  {"SelectionOpenAllGroups", 68970, 2034},
  {"SelectionCloseAllGroups", 69262, 2041},
  {"OpenCloseGroup", 69548, 2048},
  {"CellSplit", 69880, 2057},
  {"CellMerge", 70265, 2068},
  {"SelectionAnimate", 70584, 2077},
  {"SoundPlay", 71335, 2096},
  {"GraphicsRender", 71651, 2105},
  {"GenerateImageCaches", 71914, 2112},
  {"GraphicsOriginalSize", 72110, 2117},
  {"GraphicsAlign", 72385, 2124},
  {"alignGraphicsSettingsID", 72949, 2135},
  {"NotebookStatisticsDialog", 73514, 2146},
  {"notebookStatisticsDialogID", 74548, 2163}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 94, 4, 54, "Section"],
Cell[1806, 55, 62, 1, 34, "Command",
  CellTags->"ConvertToInputForm"],
Cell[1871, 58, 261, 10, 29, "Usage",
  CellTags->"ConvertToInputForm"],
Cell[2135, 70, 876, 21, 144, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[3014, 93, 175, 6, 22, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[3192, 101, 785, 23, 22, "Notes",
  CellTags->"ConvertToInputForm"],
Cell[3980, 126, 86, 1, 34, "Command",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[4069, 129, 285, 10, 29, "Usage",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[4357, 141, 616, 15, 96, "Notes",
  CellTags->{"SelectionConvert", "ConvertToOutputForm"}],
Cell[4976, 158, 90, 1, 34, "Command",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5069, 161, 291, 10, 29, "Usage",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5363, 173, 246, 6, 70, "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[5612, 181, 613, 14, 70, "Notes",
  CellTags->{"SelectionConvert", "ConvertToStandardForm"}],
Cell[6228, 197, 717, 20, 70, "Notes",
  CellTags->"ConvertToStandardForm"],
Cell[6948, 219, 96, 1, 70, "Command",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7047, 222, 301, 10, 70, "Usage",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7351, 234, 249, 6, 70, "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[7603, 242, 619, 14, 70, "Notes",
  CellTags->{"SelectionConvert", "ConvertToTraditionalForm"}],
Cell[8225, 258, 714, 19, 70, "Notes",
  CellTags->"ConvertToTraditionalForm"],
Cell[8942, 279, 77, 1, 70, "Command",
  CellTags->{"SelectionConvert", "PostScript"}],
Cell[9022, 282, 178, 5, 70, "Usage",
  CellTags->"PostScript"],
Cell[9203, 289, 162, 3, 70, "Notes",
  CellTags->"PostScript"],
Cell[9368, 294, 69, 1, 70, "Command",
  CellTags->{"SelectionConvert", "Bitmap"}],
Cell[9440, 297, 189, 5, 70, "Usage",
  CellTags->"Bitmap"],
Cell[9632, 304, 158, 3, 70, "Notes",
  CellTags->"Bitmap"],
Cell[9793, 309, 65, 1, 70, "Command",
  CellTags->{"SelectionConvert", "PICT"}],
Cell[9861, 312, 201, 6, 70, "Usage",
  CellTags->"PICT"],
Cell[10065, 320, 138, 3, 70, "Notes",
  CellTags->"PICT"],
Cell[10206, 325, 77, 1, 70, "Command",
  CellTags->{"SelectionConvert", "PICTBitmap"}],
Cell[10286, 328, 244, 6, 70, "Usage",
  CellTags->"PICTBitmap"],
Cell[10533, 336, 144, 3, 70, "Notes",
  CellTags->"PICTBitmap"],
Cell[10680, 341, 87, 1, 70, "Command",
  CellTags->{"SelectionConvert", "PICTEmbeddedPS"}],
Cell[10770, 344, 277, 6, 70, "Usage",
  CellTags->"PICTEmbeddedPS"],
Cell[11050, 352, 148, 3, 70, "Notes",
  CellTags->"PICTEmbeddedPS"],
Cell[11201, 357, 75, 1, 70, "Command",
  CellTags->{"SelectionConvert", "QuickTime"}],
Cell[11279, 360, 234, 6, 70, "Usage",
  CellTags->"QuickTime"],
Cell[11516, 368, 94, 4, 70, "Section"],
Cell[11613, 374, 80, 1, 70, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[11696, 377, 216, 5, 70, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[11915, 384, 402, 6, 70, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTextForm"}],
Cell[12320, 392, 86, 1, 70, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[12409, 395, 308, 10, 70, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[12720, 407, 428, 9, 70, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsInputForm"}],
Cell[13151, 418, 92, 1, 70, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[13246, 421, 294, 10, 70, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[13543, 433, 399, 9, 70, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsStandardForm"}],
Cell[13945, 444, 98, 1, 70, "Command",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
Cell[14046, 447, 303, 10, 70, "Usage",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
Cell[14352, 459, 405, 9, 70, "Notes",
  CellTags->{"SelectionDisplayAs", "DisplayAsTraditionalForm"}],
Cell[14760, 470, 108, 4, 70, "Section"],
Cell[14871, 476, 86, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[14960, 479, 317, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[15280, 491, 513, 13, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputInput"],
Cell[15796, 506, 92, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[15891, 509, 326, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[16220, 521, 522, 13, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputStandard"],
Cell[16745, 536, 98, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
Cell[16846, 539, 335, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
Cell[17184, 551, 531, 13, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesInputTraditional"],
Cell[17718, 566, 109, 4, 70, "Section"],
Cell[17830, 572, 89, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[17922, 575, 315, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[18240, 587, 388, 11, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputOutput"],
Cell[18631, 600, 87, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[18721, 603, 311, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[19035, 615, 385, 11, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputInput"],
Cell[19423, 628, 93, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[19519, 631, 320, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[19842, 643, 394, 11, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputStandard"],
Cell[20239, 656, 99, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
Cell[20341, 659, 330, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
Cell[20674, 671, 403, 11, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesOutputTraditional"],
Cell[21080, 684, 109, 4, 70, "Section"],
Cell[21192, 690, 97, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[21292, 693, 325, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[21620, 705, 405, 12, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineStandard"],
Cell[22028, 719, 103, 1, 70, "Command",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
Cell[22134, 722, 334, 10, 70, "Usage",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
Cell[22471, 734, 416, 12, 70, "Notes",
  CellTags->"MenuListCommonDefaultFormatTypesTextInlineTraditional"],
Cell[22890, 748, 99, 4, 70, "Section"],
Cell[22992, 754, 52, 1, 45, "Command",
  CellTags->"CellOpen"],
Cell[23047, 757, 156, 5, 40, "Usage",
  CellTags->"CellOpen"],
Cell[23206, 764, 323, 10, 67, "Notes",
  CellTags->"CellOpen"],
Cell[23532, 776, 164, 6, 33, "Notes",
  CellTags->"CellOpen"],
Cell[23699, 784, 56, 1, 34, "Command",
  CellTags->"Editable"],
Cell[23758, 787, 157, 5, 29, "Usage",
  CellTags->"Editable"],
Cell[23918, 794, 356, 11, 56, "Notes",
  CellTags->"Editable"],
Cell[24277, 807, 71, 1, 34, "Command",
  CellTags->"CellEditDuplicate"],
Cell[24351, 810, 205, 5, 29, "Usage",
  CellTags->"CellEditDuplicate"],
Cell[24559, 817, 336, 10, 56, "Notes",
  CellTags->"CellEditDuplicate"],
Cell[24898, 829, 62, 1, 34, "Command",
  CellTags->"Evaluatable"],
Cell[24963, 832, 232, 6, 43, "Usage",
  CellTags->"Evaluatable"],
Cell[25198, 840, 370, 11, 56, "Notes",
  CellTags->"Evaluatable"],
Cell[25571, 853, 52, 1, 34, "Command",
  CellTags->"Active"],
Cell[25626, 856, 165, 5, 29, "Usage",
  CellTags->"Active"],
Cell[25794, 863, 202, 4, 36, "Notes",
  CellTags->"Active"],
Cell[25999, 869, 258, 4, 42, "Notes",
  CellTags->"Active"],
Cell[26260, 875, 246, 10, 22, "Notes",
  CellTags->"Active"],
Cell[26509, 887, 93, 1, 34, "Command",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[26605, 890, 216, 5, 29, "Usage",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[26824, 897, 461, 12, 56, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[27288, 911, 728, 16, 138, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[28019, 929, 707, 14, 92, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[28729, 945, 284, 6, 36, "Notes",
  CellTags->{"InitializationCell", "askIfInitNoteID"}],
Cell[29016, 953, 97, 4, 54, "Section"],
Cell[29116, 959, 55, 1, 34, "Command",
  CellTags->"CellGroup"],
Cell[29174, 962, 172, 5, 29, "Usage",
  CellTags->"CellGroup"],
Cell[29349, 969, 251, 4, 42, "Notes",
  CellTags->"CellGroup"],
Cell[29603, 975, 353, 9, 47, "Notes",
  CellTags->"CellGroup"],
Cell[29959, 986, 148, 3, 33, "Notes",
  CellTags->"CellGroup"],
Cell[30110, 991, 249, 10, 33, "Notes",
  CellTags->"CellGroup"],
Cell[30362, 1003, 695, 20, 33, "Notes",
  CellTags->"CellGroup"],
Cell[31060, 1025, 59, 1, 45, "Command",
  CellTags->"CellUnGroup"],
Cell[31122, 1028, 163, 5, 40, "Usage",
  CellTags->"CellUnGroup"],
Cell[31288, 1035, 237, 4, 53, "Notes",
  CellTags->"CellUnGroup"],
Cell[31528, 1041, 288, 6, 47, "Notes",
  CellTags->"CellUnGroup"],
Cell[31819, 1049, 737, 21, 33, "Notes",
  CellTags->"CellUngroup"],
Cell[32559, 1072, 68, 1, 45, "Command",
  CellTags->"CellGroupingManual"],
Cell[32630, 1075, 161, 5, 40, "Usage",
  CellTags->"CellGroupingManual"],
Cell[32794, 1082, 310, 8, 53, "Notes",
  CellTags->"CellGroupingManual"],
Cell[33107, 1092, 74, 1, 70, "Command",
  CellTags->"CellGroupingAutomatic"],
Cell[33184, 1095, 214, 6, 70, "Usage",
  CellTags->"CellGroupingAutomatic"],
Cell[33401, 1103, 722, 13, 70, "Notes",
  CellTags->"CellGroupingAutomatic"],
Cell[34126, 1118, 181, 6, 70, "Notes",
  CellTags->"CellGroupingAutomatic"],
Cell[34310, 1126, 75, 1, 70, "Command",
  CellTags->"SelectionOpenAllGroups"],
Cell[34388, 1129, 181, 5, 70, "Usage",
  CellTags->"SelectionOpenAllGroups"],
Cell[34572, 1136, 768, 23, 70, "Notes",
  CellTags->"SelectionOpenAllGroups"],
Cell[35343, 1161, 77, 1, 70, "Command",
  CellTags->"SelectionCloseAllGroups"],
Cell[35423, 1164, 184, 5, 70, "Usage",
  CellTags->"SelectionCloseAllGroups"],
Cell[35610, 1171, 769, 23, 70, "Notes",
  CellTags->"SelectionCloseAllGroups"],
Cell[36382, 1196, 65, 1, 70, "Command",
  CellTags->"OpenCloseGroup"],
Cell[36450, 1199, 264, 6, 70, "Usage",
  CellTags->"OpenCloseGroup"],
Cell[36717, 1207, 184, 3, 70, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[36904, 1212, 593, 18, 70, "Notes",
  CellTags->"OpenCloseGroup"],
Cell[37500, 1232, 55, 1, 70, "Command",
  CellTags->"CellSplit"],
Cell[37558, 1235, 165, 5, 70, "Usage",
  CellTags->"CellSplit"],
Cell[37726, 1242, 191, 5, 70, "Notes",
  CellTags->"CellSplit"],
Cell[37920, 1249, 295, 5, 70, "Notes",
  CellTags->"CellSplit"],
Cell[38218, 1256, 720, 21, 70, "Notes",
  CellTags->"CellSplit"],
Cell[38941, 1279, 54, 1, 70, "Command",
  CellTags->"CellMerge"],
Cell[38998, 1282, 173, 5, 70, "Usage",
  CellTags->"CellMerge"],
Cell[39174, 1289, 227, 4, 70, "Notes",
  CellTags->"CellMerge"],
Cell[39404, 1295, 720, 21, 70, "Notes",
  CellTags->"CellMerge"],
Cell[40127, 1318, 76, 1, 70, "Command",
  CellTags->"SelectionAnimate"],
Cell[40206, 1321, 207, 5, 70, "Usage",
  CellTags->"SelectionAnimate"],
Cell[40416, 1328, 228, 5, 70, "Notes",
  CellTags->"SelectionAnimate"],
Cell[40647, 1335, 155, 3, 70, "Notes",
  CellTags->"SelectionAnimate"],
Cell[40805, 1340, 639, 19, 70, "Notes",
  CellTags->"SelectionAnimate"],
Cell[41447, 1361, 130, 2, 70, "Subsubsection",
  CellTags->"SelectionAnimate"],
Cell[41580, 1365, 457, 10, 70, "Notes",
  CellTags->"SelectionAnimate"],
Cell[42040, 1377, 134, 3, 70, "Notes",
  CellTags->"SelectionAnimate"],
Cell[42177, 1382, 5125, 134, 70, "Text",
  CellTags->"SelectionAnimate"],
Cell[47305, 1518, 54, 1, 70, "Command",
  CellTags->"SoundPlay"],
Cell[47362, 1521, 153, 5, 70, "Usage",
  CellTags->"SoundPlay"],
Cell[47518, 1528, 179, 3, 70, "Notes",
  CellTags->"SoundPlay"],
Cell[47700, 1533, 251, 4, 70, "Notes",
  CellTags->"SoundPlay"],
Cell[47954, 1539, 66, 1, 70, "Command",
  CellTags->"GraphicsRender"],
Cell[48023, 1542, 242, 6, 70, "Usage",
  CellTags->"GraphicsRender"],
Cell[48268, 1550, 194, 3, 70, "Notes",
  CellTags->"GraphicsRender"],
Cell[48465, 1555, 80, 1, 70, "Command",
  CellTags->"GenerateImageCaches"],
Cell[48548, 1558, 199, 5, 70, "Usage",
  CellTags->"GenerateImageCaches"],
Cell[48750, 1565, 73, 1, 70, "Command",
  CellTags->"GraphicsOriginalSize"],
Cell[48826, 1568, 175, 5, 70, "Usage",
  CellTags->"GraphicsOriginalSize"],
Cell[49004, 1575, 484, 9, 70, "Notes",
  CellTags->"GraphicsOriginalSize"],
Cell[49491, 1586, 103, 1, 70, "Command",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[49597, 1589, 244, 6, 70, "Usage",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[49844, 1597, 288, 4, 70, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50135, 1603, 337, 5, 70, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50475, 1610, 334, 8, 70, "Notes",
  CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"}],
Cell[50812, 1620, 114, 1, 70, "Command",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[50929, 1623, 230, 5, 70, "Usage",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],

Cell[CellGroupData[{
Cell[51184, 1632, 105, 1, 70, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[51292, 1635, 139, 1, 70, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[51468, 1641, 107, 1, 70, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[51578, 1644, 191, 4, 70, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[51806, 1653, 109, 1, 70, "DialogItem",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}],
Cell[51918, 1656, 729, 13, 70, "IndentedText",
  CellTags->{"NotebookStatisticsDialog", "notebookStatisticsDialogID"}]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

